;*******************************
;*   DEMONTRATION PROGRAM 11   *
;*      8253 TIMER/COUNTER     *
;*******************************
;
            ORG    8000H
SYSCALL     EQU    30H
U25CTRL     EQU    0E0B3H
DISBUF      EQU    9F00H
U21_CTRL    EQU    0E0BBH
U21PA       EQU    0E0B8H         ;D/A Port
U21PC       EQU    0E0BAH
U28CTRL     EQU    0E0B7H
U28PA       EQU    0E0B4H
TIMER_0     EQU    0E0BCH
TIME_CTRL   EQU    0E0BFH
CLRSCR      EQU    07             ;System call "clear screen"
ONE_TO_TWO  EQU    1DH            ;System call convert hex to seg.
SET_VECT    EQU    29H            ;System call set interrupt vector
DISPLAY     EQU    0AH
COUNTER     EQU    23H            ;Internal ram for timer/counter
LIGHT       EQU    COUNTER+1
LOOP_DSP    EQU    COUNTER+2

DEM11:      MOV    DPTR,#U25CTRL
            MOV    A,#9BH
            MOVX   @DPTR,A
            MOV    A,#80H
            MOV    DPTR,#U21_CTRL
            MOVX   @DPTR,A
            MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    COUNTER,A      ;Count round of timer int.

            MOV    DPTR,#INT1_SERV
            MOV    A,#SET_VECT
            MOV    B,#3
            LCALL  SYSCALL        ;Set interrupt vector
            MOV    A,#CLRSCR      ;Clear screen
            LCALL  SYSCALL

TIME_INIT:  MOV    DPTR,#TIME_CTRL
            MOV    A,#00110010B   ;Select timer0,mode1,16bit
            MOVX   @DPTR,A
            MOV    DPTR,#TIMER_0
            MOV    A,#0
            MOVX   @DPTR,A        ;Load LSB of timr0
            MOV    A,#60H
            MOVX   @DPTR,A        ;Load MSB of timer0
            MOV    DPTR,#U21PA
            MOV    A,#1
            MOVX   @DPTR,A        ;Trig "Gate" of timer0
            SETB   EA             ;Global interrupt
            SETB   EX1            ;External interrupt1
            MOV    LIGHT,#1       ;Display on led

MAIN12:     MOV    DPTR,#U21PC
            MOV    A,LIGHT
            MOVX   @DPTR,A
            MOV    LOOP_DSP,#15
MAIN121:    MOV    B,COUNTER
            MOV    A,#ONE_TO_TWO
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF+2
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            MOV    A,#DISPLAY
            LCALL  SYSCALL
            DJNZ   LOOP_DSP,MAIN121

            MOV    A,LIGHT
            RL     A
            MOV    LIGHT,A
            SJMP   MAIN12
            SJMP   $

INT1_SERV:  PUSH   PSW
            PUSH   DPL
            PUSH   DPH
            PUSH   ACC
            MOV    DPTR,#U21PA
            CLR    A
            MOVX   @DPTR,A
            MOV    DPTR,#TIMER_0
            MOV    A,#0
            MOVX   @DPTR,A        ;Load LSB of timr0
            MOV    A,#30H
            MOVX   @DPTR,A        ;Load MSB of timer0
            INC    COUNTER
            MOV    DPTR,#U21PA
            MOV    A,#1
            MOVX   @DPTR,A
            JNB    P3.3,$         ;Wait for pending interrupt
            POP    ACC
            POP    DPH
            POP    DPL
            POP    PSW
            RETI

            END

